define("core/scroll_manager",["exports"],(function(_exports){Object.defineProperty(_exports,"__esModule",{value:!0}),_exports.watchScrollButtonSaves=_exports.scrollToSavedPosition=_exports.saveScrollPositionToForm=_exports.saveScrollPos=_exports.initLinksScrollPos=void 0;
/**
   * Scroll manager is a class that help with saving the scroll positing when you
   * click on an action icon, and then when the page is reloaded after processing
   * the action, it scrolls you to exactly where you were. This is much nicer for
   * the user.
   *
   * To use this in your code, you need to ensure that:
   * 1. The button that triggers the action has to have a click event handler that
   *    calls saveScrollPos()
   * 2. After doing the processing, the redirect() function will add 'mdlscrollto'
   *    parameter into the redirect url automatically.
   * 3. Finally, on the page that is reloaded (which should be the same as the one
   *    the user started on) you need to call scrollToSavedPosition()
   *    on page load.
   *
   * @module     core/scroll_manager
   * @copyright  2021 The Open University
   * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
   */
let scrollingElement=null;const getScrollingElement=()=>{if(null===scrollingElement){const page=document.getElementById("page");scrollingElement=(element=>{const hasScrollableContent=element.scrollHeight>element.clientHeight,isOverflowHidden=-1!==window.getComputedStyle(element).overflowY.indexOf("hidden");return hasScrollableContent&&!isOverflowHidden})(page)?page:document.scrollingElement}return scrollingElement},getScrollPos=()=>getScrollingElement().scrollTop;_exports.saveScrollPos=elementId=>{const form=document.getElementById(elementId).closest("form");form&&saveScrollPositionToForm(form)};_exports.watchScrollButtonSaves=()=>{document.addEventListener("click",(e=>{const button=e.target.closest('[data-savescrollposition="true"]');button&&saveScrollPositionToForm(button.form)}))};const saveScrollPositionToForm=form=>{(form=>{const element=form.querySelector("input[name=mdlscrollto]");if(element)return element;const scrollPos=document.createElement("input");return scrollPos.type="hidden",scrollPos.name="mdlscrollto",form.appendChild(scrollPos),scrollPos})(form).value=getScrollPos()};_exports.saveScrollPositionToForm=saveScrollPositionToForm;_exports.initLinksScrollPos=()=>{document.addEventListener("click",(e=>{if(!e.target.closest("a[data-save-scroll=true]"))return;e.preventDefault();const url=new URL(e.target.href);url.searchParams.set("mdlscrollto",getScrollPos()),window.location=url}))};_exports.scrollToSavedPosition=()=>{const url=new URL(window.location.href);if(!url.searchParams.has("mdlscrollto"))return;const scrollPosition=url.searchParams.get("mdlscrollto"),scrollingElement=getScrollingElement();scrollingElement.scrollTo(0,scrollPosition),document.addEventListener("DOMContentLoaded",(()=>{scrollingElement.scrollTo(0,scrollPosition)}))}}));

//# sourceMappingURL=scroll_manager.min.js.map